% DBSHOW(1) 1.0
%
% September 2015

# NAME

DBshow - display reads stored in a Dazzler database

# SYNOPSIS

**DBshow** [**-unqUQ**] [**-w***int(80)*] [**-m***track*]+
                    *path:db|dam* [ *reads:FILE* | *reads:range* ... ]

# DESCRIPTION

Displays the requested reads in the database *path*.db or *path*.dam.  By default the
command applies to the trimmed database, but if **-u** is set then the entire DB is used.
If no read arguments are given then every read in the database or database block is
displayed.  Otherwise the input file or the list of supplied integer ranges give the
ordinal positions in the actively loaded portion of the db.  In the case of a file, it
should simply contain a read index, one per line.  In the other case, a read range is
either a lone integer or the symbol $, in which case the read range consists of just
that read (the last read in the database if $).  One may also give two positive
integers separated by a dash to indicate a range of integers, where again a $
represents the index of the last read in the actively loaded db.  For example,
1 3-5 $ displays reads 1, 3, 4, 5, and the last read in the active db.  As another
example, 1-$ displays every read in the active db (the default).

By default a .fasta file of the read sequences is displayed.  If the **-q** option is
set, then the QV streams are also displayed in a non-standard modification of the
fasta format.  If the **-n** option is set then the DNA sequence is *not* displayed.
If the **-Q** option is set then a .quiva file is displayed  and in this case the **-n**
and **-m** options may not be set (and the **-q** and **-w** options have no effect).

If one or more masks are set with the **-m** option then the track intervals are also
displayed in an additional header line and the bases within an interval are displayed
in the case opposite that used for all the other bases.  By default the output
sequences are in lower case and 80 chars per line.  The **-U** option specifies upper
case should be used, and the characters per line, or line width, can be set to any
positive value with the **-w** option.

The .fasta or .quiva files that are output can be converted into a DB by **fasta2DB**(1)
and **quiva2DB**(1) (if the **-q** and **-n** options are not set and no **-m** options are set),
giving one a simple way to make a DB of a subset of the reads for testing purposes.

# SEE ALSO

**daligner**(1)
