/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/check_annotation.hpp
 *
 * $Id: check_annotation.hpp,v 1.8 2005/06/23 09:54:21 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref DIAGNOSTICS_BASE_CHECK
 *
 * @test diagnostics/macros/check_annotation.t.cpp
 */
#ifndef DIAGNOSTICS__MACROS__CHECK_ANNOTATION_INCLUDE_GUARD
#define DIAGNOSTICS__MACROS__CHECK_ANNOTATION_INCLUDE_GUARD

// DIAGNOSTICS_BASE_LOG
#include <diagnostics/frame/logging_facility.hpp>

/**
 * @brief Stating a Check. 
 *
 * @param LEVEL is the level of the assertion of type @ref diagnostics::Level_t
 * @param NR_WHAT is a client-specific numerical field.
 * @param STR_WHAT is a client-specific string field.  
 * @param COND The condition which to be asserted. This condition will
 * be evaluated exactly once.
 *
 * @param ACTION can be statement (not entailed by a semi-colon) which
 * has to be executed in the case of a failing assertion. 
 */
#define DIAGNOSTICS_BASE_CHECK(LEVEL,NR_WHAT,STR_WHAT,COND,ACTION) \
    do { if(!(COND)) { \
         DIAGNOSTICS_BASE_LOG((LEVEL),::diagnostics::TYPE_FAILED_CHECK,(NR_WHAT),(STR_WHAT)); \
         ACTION; \
      } \
    } while(false)


#endif

// vim:ts=4:sw=4
