/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "commands.h"
#include "activate_button_clicked.h"
#include "apply_server_settings.h"

extern int activated;


void activate_button_clicked(struct w *widgets)
{
    gchar *info, *path;

    if( activated )
      return;

    /* See if we have required things such as certs */
    path = g_strdup_printf("%s/server/certs/cert.pem", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(path) )
    {
	info = g_strdup_printf(_("Generate new certificates in the server settings tab first.\n"));
	show_info(info);
	g_free(info);
	g_free(path);
	return;
    }
    g_free(path);

    /* Apply the server settings. Writes server conf and sysinit script */
    apply_server_settings(widgets);

    /* Start the gadmin-openvpn-server runlevel script */
    init_start(widgets);
}
