/* EPGScanner.c generated by valac 0.34.4, the Vala compiler
 * generated from EPGScanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>
#include <gst/mpegts/mpegts.h>


#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
typedef struct _DVBEPGScannerPrivate DVBEPGScannerPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
#define __vala_GstMpegtsSection_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsSection_free (var), NULL)))
#define __vala_GstMpegtsEITEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsEITEvent_free (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
#define __vala_GstMpegtsDescriptor_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsDescriptor_free (var), NULL)))
#define __vala_GstMpegtsExtendedEventDescriptor_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsExtendedEventDescriptor_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_GstMpegtsComponentDescriptor_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsComponentDescriptor_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _DVBEventVideoComponentPrivate DVBEventVideoComponentPrivate;
#define _dvb_event_video_component_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_video_component_unref (var), NULL)))
typedef struct _DVBEventAudioComponentPrivate DVBEventAudioComponentPrivate;
#define _dvb_event_audio_component_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_audio_component_unref (var), NULL)))
typedef struct _DVBEventTeletextComponentPrivate DVBEventTeletextComponentPrivate;
#define _dvb_event_teletext_component_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_teletext_component_unref (var), NULL)))

struct _DVBEPGScanner {
	GObject parent_instance;
	DVBEPGScannerPrivate * priv;
};

struct _DVBEPGScannerClass {
	GObjectClass parent_class;
};

struct _DVBEPGScannerPrivate {
	DVBDeviceGroup* DeviceGroup;
	GstElement* pipeline;
	GRecMutex __lock_pipeline;
	GQueue* channels;
	GSource* scan_source;
	GSource* queue_source;
	gint stop_counter;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	guint bus_watch_id;
	GeeHashMap* channel_events;
	GRecMutex __lock_channel_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	DVBEventVideoComponent* video_component;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DVBEventVideoComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventVideoComponentPrivate * priv;
	gboolean has_hd;
	gboolean has_3d;
	gchar* aspect_ratio;
	gint frequency;
	gchar* type;
	guint tag;
	gchar* content;
	gchar* text;
};

struct _DVBEventVideoComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventVideoComponent *self);
};

struct _DVBEventAudioComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventAudioComponentPrivate * priv;
	gchar* type;
	gchar* language;
	guint tag;
	gchar* content;
	gchar* text;
};

struct _DVBEventAudioComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventAudioComponent *self);
};

struct _DVBEventTeletextComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventTeletextComponentPrivate * priv;
	gchar* type;
	gchar* content;
	guint tag;
	gchar* text;
};

struct _DVBEventTeletextComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventTeletextComponent *self);
};


static gpointer dvb_epg_scanner_parent_class = NULL;
static DVBLoggingLogger* dvb_epg_scanner_log;
static DVBLoggingLogger* dvb_epg_scanner_log = NULL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL = -1;

GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
#define DVB_EPG_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EPG_SCANNER, DVBEPGScannerPrivate))
enum  {
	DVB_EPG_SCANNER_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION 10
#define DVB_EPG_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=0:16:17:18 stats-report" \
"ing-interval=0 ! tsparse ! fakesink silent=true"
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (DVBFactory* self);
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self);
static void dvb_epg_scanner_reset (DVBEPGScanner* self);
static void* dvb_epg_scanner_worker (DVBEPGScanner* self);
static gboolean dvb_epg_scanner_setup_pipeline (DVBEPGScanner* self);
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static void dvb_epg_scanner_reset_pipeline (DVBEPGScanner* self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self);
static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
const gchar* dvb_channel_get_Name (DVBChannel* self);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, GstMpegtsSection* section);
static void _vala_GstMpegtsSection_free (GstMpegtsSection* self);
guint dvb_event_hash (DVBEvent* event);
static guint _dvb_event_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
static gboolean _dvb_event_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static GstMpegtsEITEvent* _vala_GstMpegtsEITEvent_copy (GstMpegtsEITEvent* self);
static void _vala_GstMpegtsEITEvent_free (GstMpegtsEITEvent* self);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
gboolean dvb_event_has_expired (DVBEvent* self);
static GstMpegtsDescriptor* _vala_GstMpegtsDescriptor_copy (GstMpegtsDescriptor* self);
static void _vala_GstMpegtsDescriptor_free (GstMpegtsDescriptor* self);
static void _vala_GstMpegtsExtendedEventDescriptor_free (GstMpegtsExtendedEventDescriptor* self);
static void _vala_GstMpegtsComponentDescriptor_free (GstMpegtsComponentDescriptor* self);
static void dvb_epg_scanner_decode_component (GstMpegtsComponentDescriptor* comp, DVBEvent* event_class);
gchar* dvb_event_to_string (DVBEvent* self);
DVBEventVideoComponent* dvb_event_video_component_new (void);
DVBEventVideoComponent* dvb_event_video_component_construct (GType object_type);
DVBEventAudioComponent* dvb_event_audio_component_new (void);
DVBEventAudioComponent* dvb_event_audio_component_construct (GType object_type);
DVBEventTeletextComponent* dvb_event_teletext_component_new (void);
DVBEventTeletextComponent* dvb_event_teletext_component_construct (GType object_type);
static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_epg_scanner_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


/**
         * @device: The device where EPG should be collected from
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device) {
	DVBEPGScanner * self = NULL;
	DVBDeviceGroup* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBEPGScanner*) g_object_new (object_type, NULL);
	_tmp0_ = device;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->DeviceGroup);
	self->priv->DeviceGroup = _tmp1_;
	_tmp2_ = dvb_epg_scanner_CHECK_EIT_INTERVAL;
	if (_tmp2_ == -1) {
		DVBSettings* settings = NULL;
		DVBFactory* _tmp3_ = NULL;
		DVBFactory* _tmp4_ = NULL;
		DVBSettings* _tmp5_ = NULL;
		DVBSettings* _tmp6_ = NULL;
		DVBSettings* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp3_ = dvb_factory_new ();
		_tmp4_ = _tmp3_;
		_tmp5_ = dvb_factory_get_settings (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		settings = _tmp6_;
		_tmp7_ = settings;
		_tmp8_ = dvb_settings_get_epg_scan_interval (_tmp7_);
		dvb_epg_scanner_CHECK_EIT_INTERVAL = _tmp8_;
		_g_object_unref0 (settings);
	}
	return self;
}


DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device) {
	return dvb_epg_scanner_construct (DVB_TYPE_EPG_SCANNER, device);
}


/**
         * Stop collecting EPG data
         */
void dvb_epg_scanner_stop (DVBEPGScanner* self) {
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_epg_scanner_log;
	_tmp1_ = self->priv->DeviceGroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->stop_counter;
	dvb_logging_logger_debug (_tmp0_, "EPGScanner.vala:76: Stopping EPG scan for group %u (%d)", _tmp3_, _tmp4_);
	_tmp5_ = self->priv->stop_counter;
	if (_tmp5_ == 0) {
		dvb_epg_scanner_remove_timeouts (self);
		dvb_epg_scanner_reset (self);
	}
	_tmp6_ = self->priv->stop_counter;
	self->priv->stop_counter = _tmp6_ + 1;
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self) {
	GSource* _tmp0_ = NULL;
	GSource* _tmp2_ = NULL;
	GMainLoop* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_source;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_ = NULL;
		_tmp1_ = self->priv->scan_source;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->scan_source);
		self->priv->scan_source = NULL;
	}
	_tmp2_ = self->priv->queue_source;
	if (_tmp2_ != NULL) {
		GSource* _tmp3_ = NULL;
		_tmp3_ = self->priv->queue_source;
		g_source_destroy (_tmp3_);
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = NULL;
	}
	_tmp4_ = self->priv->loop;
	if (_tmp4_ != NULL) {
		GMainLoop* _tmp5_ = NULL;
		GThread* _tmp6_ = NULL;
		GThread* _tmp7_ = NULL;
		_tmp5_ = self->priv->loop;
		g_main_loop_quit (_tmp5_);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = NULL;
		_tmp6_ = self->priv->worker_thread;
		_tmp7_ = _g_thread_ref0 (_tmp6_);
		g_thread_join (_tmp7_);
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
}


static void* dvb_epg_scanner_worker (DVBEPGScanner* self) {
	void* result = NULL;
	GMainLoop* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->loop;
	g_main_loop_run (_tmp0_);
	result = NULL;
	return result;
}


static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_bus_watch_func ((DVBEPGScanner*) self, bus, message);
	return result;
}


static gboolean dvb_epg_scanner_setup_pipeline (DVBEPGScanner* self) {
	gboolean result = FALSE;
	DVBDevice* device = NULL;
	DVBDeviceGroup* _tmp0_ = NULL;
	DVBDevice* _tmp1_ = NULL;
	DVBDevice* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->DeviceGroup;
	_tmp1_ = dvb_device_group_get_next_free_device (_tmp0_);
	device = _tmp1_;
	_tmp2_ = device;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	{
		GstElement* _tmp3_ = NULL;
		_tmp3_ = self->priv->pipeline;
		g_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstBus* bus = NULL;
			GstElement* _tmp21_ = NULL;
			GstBus* _tmp22_ = NULL;
			GstBus* _tmp23_ = NULL;
			GMainContext* _tmp24_ = NULL;
			guint _tmp25_ = 0U;
			{
				GstElement* _tmp4_ = NULL;
				DVBDevice* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				guint _tmp7_ = 0U;
				DVBDevice* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				GstElement* _tmp13_ = NULL;
				GstElement* _tmp14_ = NULL;
				GstElement* _tmp15_ = NULL;
				_tmp5_ = device;
				_tmp6_ = dvb_device_get_Adapter (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = device;
				_tmp9_ = dvb_device_get_Frontend (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf (DVB_EPG_SCANNER_PIPELINE_TEMPLATE, _tmp7_, _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gst_parse_launch_full (_tmp12_, NULL, GST_PARSE_FLAG_NONE, &_inner_error_);
				g_object_ref_sink (_tmp13_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				_tmp4_ = _tmp14_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch59_g_error;
				}
				_tmp15_ = _tmp4_;
				_tmp4_ = NULL;
				g_object_ref_sink (_tmp15_);
				_g_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = _tmp15_;
				_g_object_unref0 (_tmp4_);
			}
			goto __finally59;
			__catch59_g_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp16_ = NULL;
				GError* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp16_ = dvb_epg_scanner_log;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				dvb_logging_logger_error (_tmp16_, "EPGScanner.vala:119: Could not create pipeline: %s", _tmp18_);
				result = FALSE;
				_g_error_free0 (e);
				{
					GstElement* _tmp19_ = NULL;
					_tmp19_ = self->priv->pipeline;
					g_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				return result;
			}
			__finally59:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				{
					GstElement* _tmp20_ = NULL;
					_tmp20_ = self->priv->pipeline;
					g_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp21_ = self->priv->pipeline;
			_tmp22_ = gst_element_get_bus (_tmp21_);
			bus = _tmp22_;
			_tmp23_ = bus;
			_tmp24_ = self->priv->context;
			_tmp25_ = gst_bus_add_watch_context (_tmp23_, _dvb_epg_scanner_bus_watch_func_gst_bus_func, self, _tmp24_);
			self->priv->bus_watch_id = _tmp25_;
			_g_object_unref0 (bus);
		}
		__finally58:
		{
			GstElement* _tmp26_ = NULL;
			_tmp26_ = self->priv->pipeline;
			g_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (device);
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


static void dvb_epg_scanner_reset_pipeline (DVBEPGScanner* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GstElement* _tmp0_ = NULL;
		_tmp0_ = self->priv->pipeline;
		g_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp1_ = NULL;
			_tmp1_ = self->priv->pipeline;
			if (_tmp1_ != NULL) {
				GSource* bus_watch_source = NULL;
				GMainContext* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				GSource* _tmp4_ = NULL;
				GSource* _tmp5_ = NULL;
				GSource* _tmp6_ = NULL;
				GstElement* _tmp8_ = NULL;
				GstElement* _tmp9_ = NULL;
				_tmp2_ = self->priv->context;
				_tmp3_ = self->priv->bus_watch_id;
				_tmp4_ = g_main_context_find_source_by_id (_tmp2_, _tmp3_);
				_tmp5_ = _g_source_ref0 (_tmp4_);
				bus_watch_source = _tmp5_;
				_tmp6_ = bus_watch_source;
				if (_tmp6_ != NULL) {
					GSource* _tmp7_ = NULL;
					_tmp7_ = bus_watch_source;
					g_source_destroy (_tmp7_);
					self->priv->bus_watch_id = (guint) 0;
				}
				_tmp8_ = self->priv->pipeline;
				gst_element_set_state (_tmp8_, GST_STATE_NULL);
				_tmp9_ = self->priv->pipeline;
				gst_element_get_state (_tmp9_, NULL, NULL, (GstClockTime) -1);
				_g_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = NULL;
				_g_source_unref0 (bus_watch_source);
			}
		}
		__finally60:
		{
			GstElement* _tmp10_ = NULL;
			_tmp10_ = self->priv->pipeline;
			g_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_epg_scanner_reset (DVBEPGScanner* self) {
	DVBChannel* c = NULL;
	GQueue* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_epg_scanner_reset_pipeline (self);
	while (TRUE) {
		GQueue* _tmp0_ = NULL;
		gpointer _tmp1_ = NULL;
		DVBChannel* _tmp2_ = NULL;
		_tmp0_ = self->priv->channels;
		_tmp1_ = g_queue_pop_head (_tmp0_);
		_g_object_unref0 (c);
		c = (DVBChannel*) _tmp1_;
		_tmp2_ = c;
		if (!(_tmp2_ != NULL)) {
			break;
		}
	}
	_tmp3_ = self->priv->channels;
	g_queue_clear (_tmp3_);
	_tmp4_ = self->priv->channel_events;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp4_);
	_g_object_unref0 (c);
}


/**
         * Start collection EPG data for all channels
         */
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_epg_scanner_worker ((DVBEPGScanner*) self);
	g_object_unref (self);
	return result;
}


static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_scan_new_frequency ((DVBEPGScanner*) self);
	return result;
}


gboolean dvb_epg_scanner_start (DVBEPGScanner* self) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	GMainLoop* _tmp5_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp27_ = FALSE;
	GSource* _tmp28_ = NULL;
	GSource* _tmp29_ = NULL;
	GSource* _tmp30_ = NULL;
	GMainContext* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_epg_scanner_log;
	_tmp1_ = self->priv->DeviceGroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->stop_counter;
	dvb_logging_logger_debug (_tmp0_, "EPGScanner.vala:162: Starting EPG scan for group %u (%d)", _tmp3_, _tmp4_);
	_tmp5_ = self->priv->loop;
	if (_tmp5_ == NULL) {
		GMainContext* _tmp6_ = NULL;
		GMainLoop* _tmp7_ = NULL;
		_tmp6_ = self->priv->context;
		_tmp7_ = g_main_loop_new (_tmp6_, FALSE);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = _tmp7_;
		{
			GThread* _tmp8_ = NULL;
			GThread* _tmp9_ = NULL;
			GThread* _tmp10_ = NULL;
			_tmp9_ = g_thread_try_new ("EPG-Worker-Thread", _dvb_epg_scanner_worker_gthread_func, g_object_ref (self), &_inner_error_);
			_tmp8_ = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch61_g_error;
			}
			_tmp10_ = _tmp8_;
			_tmp8_ = NULL;
			_g_thread_unref0 (self->priv->worker_thread);
			self->priv->worker_thread = _tmp10_;
			_g_thread_unref0 (_tmp8_);
		}
		goto __finally61;
		__catch61_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = dvb_epg_scanner_log;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			dvb_logging_logger_error (_tmp11_, "EPGScanner.vala:169: Could not create thread: %s", _tmp13_);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally61:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp14_ = self->priv->stop_counter;
	self->priv->stop_counter = _tmp14_ - 1;
	_tmp15_ = self->priv->stop_counter;
	if (_tmp15_ > 0) {
		result = FALSE;
		return result;
	}
	self->priv->stop_counter = 0;
	{
		GeeIterator* _c_it = NULL;
		DVBDeviceGroup* _tmp16_ = NULL;
		DVBChannelList* _tmp17_ = NULL;
		DVBChannelList* _tmp18_ = NULL;
		GeeIterator* _tmp19_ = NULL;
		_tmp16_ = self->priv->DeviceGroup;
		_tmp17_ = dvb_device_group_get_Channels (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_c_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			DVBChannel* c = NULL;
			GeeIterator* _tmp22_ = NULL;
			gpointer _tmp23_ = NULL;
			GQueue* _tmp24_ = NULL;
			DVBChannel* _tmp25_ = NULL;
			DVBChannel* _tmp26_ = NULL;
			_tmp20_ = _c_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _c_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			c = (DVBChannel*) _tmp23_;
			_tmp24_ = self->priv->channels;
			_tmp25_ = c;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			g_queue_push_tail (_tmp24_, _tmp26_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	_tmp27_ = dvb_epg_scanner_setup_pipeline (self);
	if (!_tmp27_) {
		result = FALSE;
		return result;
	}
	_tmp28_ = g_timeout_source_new_seconds ((guint) DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION);
	_g_source_unref0 (self->priv->scan_source);
	self->priv->scan_source = _tmp28_;
	_tmp29_ = self->priv->scan_source;
	g_source_set_callback (_tmp29_, _dvb_epg_scanner_scan_new_frequency_gsource_func, g_object_ref (self), g_object_unref);
	_tmp30_ = self->priv->scan_source;
	_tmp31_ = self->priv->context;
	g_source_attach (_tmp30_, _tmp31_);
	result = FALSE;
	return result;
}


/**
         * Scan the next frequency for EPG data
         */
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_start ((DVBEPGScanner*) self);
	return result;
}


static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self) {
	gboolean result = FALSE;
	DVBChannelList* clist = NULL;
	DVBDeviceGroup* _tmp0_ = NULL;
	DVBChannelList* _tmp1_ = NULL;
	DVBChannelList* _tmp2_ = NULL;
	DVBChannelList* _tmp3_ = NULL;
	DVBChannelList* _tmp4_ = NULL;
	GQueue* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	DVBChannel* channel = NULL;
	GQueue* _tmp49_ = NULL;
	gpointer _tmp50_ = NULL;
	DVBChannel* _tmp51_ = NULL;
	DVBSchedule* _tmp52_ = NULL;
	DVBSchedule* _tmp53_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->DeviceGroup;
	_tmp1_ = dvb_device_group_get_Channels (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clist = _tmp3_;
	_tmp4_ = clist;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_object_unref0 (clist);
		return result;
	}
	{
		GeeHashMap* _tmp5_ = NULL;
		_tmp5_ = self->priv->channel_events;
		g_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			GeeHashMap* _tmp36_ = NULL;
			{
				GeeIterator* _sid_it = NULL;
				GeeHashMap* _tmp6_ = NULL;
				GeeSet* _tmp7_ = NULL;
				GeeSet* _tmp8_ = NULL;
				GeeSet* _tmp9_ = NULL;
				GeeIterator* _tmp10_ = NULL;
				GeeIterator* _tmp11_ = NULL;
				_tmp6_ = self->priv->channel_events;
				_tmp7_ = gee_abstract_map_get_keys ((GeeMap*) _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp9_);
				_sid_it = _tmp11_;
				while (TRUE) {
					GeeIterator* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					guint sid = 0U;
					GeeIterator* _tmp14_ = NULL;
					gpointer _tmp15_ = NULL;
					DVBChannel* channel = NULL;
					DVBChannelList* _tmp16_ = NULL;
					guint _tmp17_ = 0U;
					DVBChannel* _tmp18_ = NULL;
					DVBChannel* _tmp19_ = NULL;
					GeeHashSet* list = NULL;
					GeeHashMap* _tmp21_ = NULL;
					guint _tmp22_ = 0U;
					gpointer _tmp23_ = NULL;
					DVBLoggingLogger* _tmp24_ = NULL;
					GeeHashSet* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					DVBChannel* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					guint _tmp31_ = 0U;
					DVBChannel* _tmp32_ = NULL;
					DVBSchedule* _tmp33_ = NULL;
					DVBSchedule* _tmp34_ = NULL;
					GeeHashSet* _tmp35_ = NULL;
					_tmp12_ = _sid_it;
					_tmp13_ = gee_iterator_next (_tmp12_);
					if (!_tmp13_) {
						break;
					}
					_tmp14_ = _sid_it;
					_tmp15_ = gee_iterator_get (_tmp14_);
					sid = (guint) ((guintptr) _tmp15_);
					_tmp16_ = clist;
					_tmp17_ = sid;
					_tmp18_ = dvb_channel_list_get_channel (_tmp16_, _tmp17_);
					channel = _tmp18_;
					_tmp19_ = channel;
					if (_tmp19_ == NULL) {
						guint _tmp20_ = 0U;
						_tmp20_ = sid;
						g_warning ("EPGScanner.vala:203: Could not find channel %u for this device", _tmp20_);
						_g_object_unref0 (channel);
						continue;
					}
					_tmp21_ = self->priv->channel_events;
					_tmp22_ = sid;
					_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, (gpointer) ((guintptr) _tmp22_));
					list = (GeeHashSet*) _tmp23_;
					_tmp24_ = dvb_epg_scanner_log;
					_tmp25_ = list;
					_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = channel;
					_tmp29_ = dvb_channel_get_Name (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = sid;
					dvb_logging_logger_debug (_tmp24_, "EPGScanner.vala:208: Adding %d events of channel %s (%u)", _tmp27_, _tmp30_, _tmp31_);
					_tmp32_ = channel;
					_tmp33_ = dvb_channel_get_Schedule (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = list;
					dvb_schedule_add_all (_tmp34_, (GeeCollection*) _tmp35_);
					_g_object_unref0 (list);
					_g_object_unref0 (channel);
				}
				_g_object_unref0 (_sid_it);
			}
			_tmp36_ = self->priv->channel_events;
			gee_abstract_map_clear ((GeeAbstractMap*) _tmp36_);
		}
		__finally62:
		{
			GeeHashMap* _tmp37_ = NULL;
			_tmp37_ = self->priv->channel_events;
			g_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (clist);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp38_ = self->priv->channels;
	_tmp39_ = g_queue_is_empty (_tmp38_);
	if (_tmp39_) {
		DVBLoggingLogger* _tmp40_ = NULL;
		DVBDeviceGroup* _tmp41_ = NULL;
		guint _tmp42_ = 0U;
		guint _tmp43_ = 0U;
		gint _tmp44_ = 0;
		GSource* _tmp45_ = NULL;
		GSource* _tmp46_ = NULL;
		GSource* _tmp47_ = NULL;
		GMainContext* _tmp48_ = NULL;
		_tmp40_ = dvb_epg_scanner_log;
		_tmp41_ = self->priv->DeviceGroup;
		_tmp42_ = dvb_device_group_get_Id (_tmp41_);
		_tmp43_ = _tmp42_;
		dvb_logging_logger_debug (_tmp40_, "EPGScanner.vala:216: Finished EPG scan for group %u", _tmp43_);
		dvb_epg_scanner_reset (self);
		_tmp44_ = dvb_epg_scanner_CHECK_EIT_INTERVAL;
		_tmp45_ = g_timeout_source_new_seconds ((guint) _tmp44_);
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = _tmp45_;
		_tmp46_ = self->priv->queue_source;
		g_source_set_callback (_tmp46_, _dvb_epg_scanner_start_gsource_func, g_object_ref (self), g_object_unref);
		_tmp47_ = self->priv->queue_source;
		_tmp48_ = self->priv->context;
		g_source_attach (_tmp47_, _tmp48_);
		result = FALSE;
		_g_object_unref0 (clist);
		return result;
	}
	_tmp49_ = self->priv->channels;
	_tmp50_ = g_queue_pop_head (_tmp49_);
	channel = (DVBChannel*) _tmp50_;
	_tmp51_ = channel;
	_tmp52_ = dvb_channel_get_Schedule (_tmp51_);
	_tmp53_ = _tmp52_;
	dvb_schedule_remove_expired_events (_tmp53_);
	{
		GstElement* _tmp54_ = NULL;
		_tmp54_ = self->priv->pipeline;
		g_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp55_ = NULL;
			GstElement* dvbsrc = NULL;
			GstElement* _tmp56_ = NULL;
			GstElement* _tmp57_ = NULL;
			DVBChannel* _tmp58_ = NULL;
			GstElement* _tmp59_ = NULL;
			GstElement* _tmp60_ = NULL;
			_tmp55_ = self->priv->pipeline;
			gst_element_set_state (_tmp55_, GST_STATE_READY);
			_tmp56_ = self->priv->pipeline;
			_tmp57_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gst_bin_get_type (), GstBin), "dvbsrc");
			dvbsrc = _tmp57_;
			_tmp58_ = channel;
			_tmp59_ = dvbsrc;
			dvb_channel_setup_dvb_source (_tmp58_, _tmp59_);
			_tmp60_ = self->priv->pipeline;
			gst_element_set_state (_tmp60_, GST_STATE_PLAYING);
			_g_object_unref0 (dvbsrc);
		}
		__finally63:
		{
			GstElement* _tmp61_ = NULL;
			_tmp61_ = self->priv->pipeline;
			g_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (channel);
			_g_object_unref0 (clist);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (channel);
	_g_object_unref0 (clist);
	return result;
}


static void _vala_GstMpegtsSection_free (GstMpegtsSection* self) {
	g_boxed_free (gst_mpegts_section_get_type (), self);
}


static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ELEMENT:
		{
			GstMpegtsSection* section = NULL;
			GstMessage* _tmp2_ = NULL;
			GstMpegtsSection* _tmp3_ = NULL;
			GstMpegtsSection* _tmp4_ = NULL;
			_tmp2_ = message;
			_tmp3_ = gst_message_parse_mpegts_section (_tmp2_);
			section = _tmp3_;
			_tmp4_ = section;
			if (_tmp4_ == NULL) {
				GstStructure* structure = NULL;
				GstMessage* _tmp5_ = NULL;
				GstStructure* _tmp6_ = NULL;
				GstStructure* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				_tmp5_ = message;
				_tmp6_ = gst_message_get_structure (_tmp5_);
				structure = _tmp6_;
				_tmp7_ = structure;
				_tmp8_ = gst_structure_get_name (_tmp7_);
				if (g_strcmp0 (_tmp8_, "dvb-read-failure") == 0) {
					DVBLoggingLogger* _tmp9_ = NULL;
					_tmp9_ = dvb_epg_scanner_log;
					dvb_logging_logger_warning (_tmp9_, "EPGScanner.vala:251: Could not read from DVB device");
				}
			} else {
				GstMpegtsSection* _tmp10_ = NULL;
				GstMpegtsSectionType _tmp11_ = 0;
				_tmp10_ = section;
				_tmp11_ = _tmp10_->section_type;
				if (_tmp11_ == GST_MPEGTS_SECTION_EIT) {
					GstMpegtsSection* _tmp12_ = NULL;
					_tmp12_ = section;
					dvb_epg_scanner_on_eit_structure (self, _tmp12_);
				}
			}
			__vala_GstMpegtsSection_free0 (section);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* gerror = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			DVBLoggingLogger* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp13_ = message;
			gst_message_parse_error (_tmp13_, &_tmp14_, &_tmp15_);
			_g_error_free0 (gerror);
			gerror = _tmp14_;
			_g_free0 (debug);
			debug = _tmp15_;
			_tmp16_ = dvb_epg_scanner_log;
			_tmp17_ = gerror;
			_tmp18_ = _tmp17_->message;
			_tmp19_ = debug;
			dvb_logging_logger_error (_tmp16_, "EPGScanner.vala:261: %s %s", _tmp18_, _tmp19_);
			dvb_epg_scanner_reset_pipeline (self);
			_tmp20_ = dvb_epg_scanner_setup_pipeline (self);
			if (_tmp20_) {
				result = TRUE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			} else {
				dvb_epg_scanner_reset (self);
				result = FALSE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			}
			_g_free0 (debug);
			_g_error_free0 (gerror);
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static guint _dvb_event_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = dvb_event_hash ((DVBEvent*) v);
	return result;
}


static gboolean _dvb_event_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = dvb_event_equal ((DVBEvent*) a, (DVBEvent*) b);
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static GstMpegtsEITEvent* _vala_GstMpegtsEITEvent_copy (GstMpegtsEITEvent* self) {
	return g_boxed_copy (gst_mpegts_eit_event_get_type (), self);
}


static gpointer __vala_GstMpegtsEITEvent_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsEITEvent_copy (self) : NULL;
}


static void _vala_GstMpegtsEITEvent_free (GstMpegtsEITEvent* self) {
	g_boxed_free (gst_mpegts_eit_event_get_type (), self);
}


static GstMpegtsDescriptor* _vala_GstMpegtsDescriptor_copy (GstMpegtsDescriptor* self) {
	return g_boxed_copy (gst_mpegts_descriptor_get_type (), self);
}


static gpointer __vala_GstMpegtsDescriptor_copy0 (gpointer self) {
	return self ? _vala_GstMpegtsDescriptor_copy (self) : NULL;
}


static void _vala_GstMpegtsDescriptor_free (GstMpegtsDescriptor* self) {
	g_boxed_free (gst_mpegts_descriptor_get_type (), self);
}


static void _vala_GstMpegtsExtendedEventDescriptor_free (GstMpegtsExtendedEventDescriptor* self) {
	g_boxed_free (gst_mpegts_extended_event_descriptor_get_type (), self);
}


static void _vala_GstMpegtsComponentDescriptor_free (GstMpegtsComponentDescriptor* self) {
	g_boxed_free (gst_mpegts_component_descriptor_get_type (), self);
}


void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, GstMpegtsSection* section) {
	GstMpegtsEIT* eit = NULL;
	GstMpegtsSection* _tmp0_ = NULL;
	GstMpegtsEIT* _tmp1_ = NULL;
	GstMpegtsEIT* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	_tmp1_ = gst_mpegts_section_get_eit (_tmp0_);
	eit = _tmp1_;
	_tmp2_ = eit;
	if (_tmp2_ == NULL) {
		return;
	}
	{
		GeeHashMap* _tmp3_ = NULL;
		_tmp3_ = self->priv->channel_events;
		g_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			guint sid = 0U;
			GstMpegtsSection* _tmp4_ = NULL;
			guint16 _tmp5_ = 0U;
			GeeHashMap* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
			gboolean _tmp8_ = FALSE;
			GeeHashSet* list = NULL;
			GeeHashMap* _tmp13_ = NULL;
			guint _tmp14_ = 0U;
			gpointer _tmp15_ = NULL;
			GstMpegtsEITEvent* event = NULL;
			guint len = 0U;
			GstMpegtsEIT* _tmp16_ = NULL;
			GPtrArray* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp4_ = section;
			_tmp5_ = _tmp4_->subtable_extension;
			sid = (guint) _tmp5_;
			_tmp6_ = self->priv->channel_events;
			_tmp7_ = sid;
			_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, (gpointer) ((guintptr) _tmp7_));
			if (!_tmp8_) {
				GeeHashMap* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				GeeHashSet* _tmp11_ = NULL;
				GeeHashSet* _tmp12_ = NULL;
				_tmp9_ = self->priv->channel_events;
				_tmp10_ = sid;
				_tmp11_ = gee_hash_set_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, _dvb_event_hash_gee_hash_data_func, NULL, NULL, _dvb_event_equal_gee_equal_data_func, NULL, NULL);
				_tmp12_ = _tmp11_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, (gpointer) ((guintptr) _tmp10_), _tmp12_);
				_g_object_unref0 (_tmp12_);
			}
			_tmp13_ = self->priv->channel_events;
			_tmp14_ = sid;
			_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, (gpointer) ((guintptr) _tmp14_));
			list = (GeeHashSet*) _tmp15_;
			_tmp16_ = eit;
			_tmp17_ = _tmp16_->events;
			_tmp18_ = g_ptr_array_get_length (_tmp17_);
			_tmp19_ = _tmp18_;
			len = (guint) _tmp19_;
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp20_ = FALSE;
					_tmp20_ = TRUE;
					while (TRUE) {
						guint _tmp22_ = 0U;
						guint _tmp23_ = 0U;
						GstMpegtsEIT* _tmp24_ = NULL;
						GPtrArray* _tmp25_ = NULL;
						guint _tmp26_ = 0U;
						gconstpointer _tmp27_ = NULL;
						GstMpegtsEITEvent* _tmp28_ = NULL;
						DVBEvent* event_class = NULL;
						DVBEvent* _tmp29_ = NULL;
						DVBEvent* _tmp30_ = NULL;
						GstMpegtsEITEvent* _tmp31_ = NULL;
						guint16 _tmp32_ = 0U;
						DVBEvent* _tmp33_ = NULL;
						GstMpegtsEITEvent* _tmp34_ = NULL;
						GstDateTime* _tmp35_ = NULL;
						gint _tmp36_ = 0;
						DVBEvent* _tmp37_ = NULL;
						GstMpegtsEITEvent* _tmp38_ = NULL;
						GstDateTime* _tmp39_ = NULL;
						gint _tmp40_ = 0;
						DVBEvent* _tmp41_ = NULL;
						GstMpegtsEITEvent* _tmp42_ = NULL;
						GstDateTime* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						DVBEvent* _tmp45_ = NULL;
						GstMpegtsEITEvent* _tmp46_ = NULL;
						GstDateTime* _tmp47_ = NULL;
						gint _tmp48_ = 0;
						DVBEvent* _tmp49_ = NULL;
						GstMpegtsEITEvent* _tmp50_ = NULL;
						GstDateTime* _tmp51_ = NULL;
						gint _tmp52_ = 0;
						DVBEvent* _tmp53_ = NULL;
						GstMpegtsEITEvent* _tmp54_ = NULL;
						GstDateTime* _tmp55_ = NULL;
						gint _tmp56_ = 0;
						DVBEvent* _tmp57_ = NULL;
						GstMpegtsEITEvent* _tmp58_ = NULL;
						guint32 _tmp59_ = 0U;
						DVBEvent* _tmp60_ = NULL;
						gboolean _tmp61_ = FALSE;
						DVBEvent* _tmp62_ = NULL;
						GstMpegtsEITEvent* _tmp63_ = NULL;
						GstMpegtsRunningStatus _tmp64_ = 0;
						DVBEvent* _tmp65_ = NULL;
						GstMpegtsEITEvent* _tmp66_ = NULL;
						gboolean _tmp67_ = FALSE;
						GstMpegtsDescriptor* desc = NULL;
						DVBLoggingLogger* _tmp133_ = NULL;
						DVBEvent* _tmp134_ = NULL;
						gchar* _tmp135_ = NULL;
						gchar* _tmp136_ = NULL;
						GeeHashSet* _tmp137_ = NULL;
						DVBEvent* _tmp138_ = NULL;
						if (!_tmp20_) {
							guint _tmp21_ = 0U;
							_tmp21_ = i;
							i = _tmp21_ + 1;
						}
						_tmp20_ = FALSE;
						_tmp22_ = i;
						_tmp23_ = len;
						if (!(_tmp22_ < _tmp23_)) {
							break;
						}
						_tmp24_ = eit;
						_tmp25_ = _tmp24_->events;
						_tmp26_ = i;
						_tmp27_ = g_ptr_array_index (_tmp25_, _tmp26_);
						_tmp28_ = __vala_GstMpegtsEITEvent_copy0 ((GstMpegtsEITEvent*) _tmp27_);
						__vala_GstMpegtsEITEvent_free0 (event);
						event = _tmp28_;
						_tmp29_ = dvb_event_new ();
						event_class = _tmp29_;
						_tmp30_ = event_class;
						_tmp31_ = event;
						_tmp32_ = _tmp31_->event_id;
						_tmp30_->id = (guint) _tmp32_;
						_tmp33_ = event_class;
						_tmp34_ = event;
						_tmp35_ = _tmp34_->start_time;
						_tmp36_ = gst_date_time_get_year (_tmp35_);
						_tmp33_->year = (guint) _tmp36_;
						_tmp37_ = event_class;
						_tmp38_ = event;
						_tmp39_ = _tmp38_->start_time;
						_tmp40_ = gst_date_time_get_month (_tmp39_);
						_tmp37_->month = (guint) _tmp40_;
						_tmp41_ = event_class;
						_tmp42_ = event;
						_tmp43_ = _tmp42_->start_time;
						_tmp44_ = gst_date_time_get_day (_tmp43_);
						_tmp41_->day = (guint) _tmp44_;
						_tmp45_ = event_class;
						_tmp46_ = event;
						_tmp47_ = _tmp46_->start_time;
						_tmp48_ = gst_date_time_get_hour (_tmp47_);
						_tmp45_->hour = (guint) _tmp48_;
						_tmp49_ = event_class;
						_tmp50_ = event;
						_tmp51_ = _tmp50_->start_time;
						_tmp52_ = gst_date_time_get_minute (_tmp51_);
						_tmp49_->minute = (guint) _tmp52_;
						_tmp53_ = event_class;
						_tmp54_ = event;
						_tmp55_ = _tmp54_->start_time;
						_tmp56_ = gst_date_time_get_second (_tmp55_);
						_tmp53_->second = (guint) _tmp56_;
						_tmp57_ = event_class;
						_tmp58_ = event;
						_tmp59_ = _tmp58_->duration;
						_tmp57_->duration = (guint) _tmp59_;
						_tmp60_ = event_class;
						_tmp61_ = dvb_event_has_expired (_tmp60_);
						if (_tmp61_) {
							_dvb_event_unref0 (event_class);
							continue;
						}
						_tmp62_ = event_class;
						_tmp63_ = event;
						_tmp64_ = _tmp63_->running_status;
						_tmp62_->running_status = (guint) _tmp64_;
						_tmp65_ = event_class;
						_tmp66_ = event;
						_tmp67_ = _tmp66_->free_CA_mode;
						_tmp65_->free_ca_mode = _tmp67_;
						{
							guint j = 0U;
							j = (guint) 0;
							{
								gboolean _tmp68_ = FALSE;
								_tmp68_ = TRUE;
								while (TRUE) {
									guint _tmp70_ = 0U;
									GstMpegtsEITEvent* _tmp71_ = NULL;
									GPtrArray* _tmp72_ = NULL;
									gint _tmp73_ = 0;
									gint _tmp74_ = 0;
									GstMpegtsEITEvent* _tmp75_ = NULL;
									GPtrArray* _tmp76_ = NULL;
									guint _tmp77_ = 0U;
									gconstpointer _tmp78_ = NULL;
									GstMpegtsDescriptor* _tmp79_ = NULL;
									GstMpegtsDescriptor* _tmp80_ = NULL;
									guint8 _tmp81_ = 0U;
									if (!_tmp68_) {
										guint _tmp69_ = 0U;
										_tmp69_ = j;
										j = _tmp69_ + 1;
									}
									_tmp68_ = FALSE;
									_tmp70_ = j;
									_tmp71_ = event;
									_tmp72_ = _tmp71_->descriptors;
									_tmp73_ = g_ptr_array_get_length (_tmp72_);
									_tmp74_ = _tmp73_;
									if (!(_tmp70_ < ((guint) _tmp74_))) {
										break;
									}
									_tmp75_ = event;
									_tmp76_ = _tmp75_->descriptors;
									_tmp77_ = j;
									_tmp78_ = g_ptr_array_index (_tmp76_, _tmp77_);
									_tmp79_ = __vala_GstMpegtsDescriptor_copy0 ((GstMpegtsDescriptor*) _tmp78_);
									__vala_GstMpegtsDescriptor_free0 (desc);
									desc = _tmp79_;
									_tmp80_ = desc;
									_tmp81_ = _tmp80_->tag;
									switch (_tmp81_) {
										case GST_MTS_DESC_DVB_SHORT_EVENT:
										{
											gchar* lang = NULL;
											GstMpegtsDescriptor* _tmp82_ = NULL;
											DVBEvent* _tmp83_ = NULL;
											DVBEvent* _tmp84_ = NULL;
											gchar* _tmp85_ = NULL;
											gchar* _tmp86_ = NULL;
											gchar* _tmp87_ = NULL;
											_tmp82_ = desc;
											_tmp83_ = event_class;
											_tmp84_ = event_class;
											gst_mpegts_descriptor_parse_dvb_short_event (_tmp82_, &_tmp85_, &_tmp86_, &_tmp87_);
											_g_free0 (lang);
											lang = _tmp85_;
											_g_free0 (_tmp83_->name);
											_tmp83_->name = _tmp86_;
											_g_free0 (_tmp84_->description);
											_tmp84_->description = _tmp87_;
											_g_free0 (lang);
											break;
										}
										case GST_MTS_DESC_DVB_EXTENDED_EVENT:
										{
											GstMpegtsExtendedEventDescriptor* ex_desc = NULL;
											GstMpegtsDescriptor* _tmp88_ = NULL;
											GstMpegtsExtendedEventDescriptor* _tmp89_ = NULL;
											gboolean _tmp90_ = FALSE;
											GString* builder = NULL;
											GString* _tmp92_ = NULL;
											DVBEvent* _tmp93_ = NULL;
											const gchar* _tmp94_ = NULL;
											GString* _tmp98_ = NULL;
											GstMpegtsExtendedEventDescriptor* _tmp99_ = NULL;
											const gchar* _tmp100_ = NULL;
											DVBEvent* _tmp101_ = NULL;
											GString* _tmp102_ = NULL;
											const gchar* _tmp103_ = NULL;
											gchar* _tmp104_ = NULL;
											_tmp88_ = desc;
											_tmp90_ = gst_mpegts_descriptor_parse_dvb_extended_event (_tmp88_, &_tmp89_);
											__vala_GstMpegtsExtendedEventDescriptor_free0 (ex_desc);
											ex_desc = _tmp89_;
											if (!_tmp90_) {
												DVBLoggingLogger* _tmp91_ = NULL;
												_tmp91_ = dvb_epg_scanner_log;
												dvb_logging_logger_debug (_tmp91_, "EPGScanner.vala:326: Failed parse extended Event");
											}
											_tmp92_ = g_string_new ("");
											builder = _tmp92_;
											_tmp93_ = event_class;
											_tmp94_ = _tmp93_->extended_description;
											if (_tmp94_ != NULL) {
												GString* _tmp95_ = NULL;
												DVBEvent* _tmp96_ = NULL;
												const gchar* _tmp97_ = NULL;
												_tmp95_ = builder;
												_tmp96_ = event_class;
												_tmp97_ = _tmp96_->extended_description;
												g_string_append (_tmp95_, _tmp97_);
											}
											_tmp98_ = builder;
											_tmp99_ = ex_desc;
											_tmp100_ = _tmp99_->text;
											g_string_append (_tmp98_, _tmp100_);
											_tmp101_ = event_class;
											_tmp102_ = builder;
											_tmp103_ = _tmp102_->str;
											_tmp104_ = g_strdup (_tmp103_);
											_g_free0 (_tmp101_->extended_description);
											_tmp101_->extended_description = _tmp104_;
											_g_string_free0 (builder);
											__vala_GstMpegtsExtendedEventDescriptor_free0 (ex_desc);
											break;
										}
										case GST_MTS_DESC_DVB_COMPONENT:
										{
											GstMpegtsComponentDescriptor* comp = NULL;
											GstMpegtsDescriptor* _tmp105_ = NULL;
											GstMpegtsComponentDescriptor* _tmp106_ = NULL;
											GstMpegtsComponentDescriptor* _tmp107_ = NULL;
											DVBEvent* _tmp108_ = NULL;
											_tmp105_ = desc;
											gst_mpegts_descriptor_parse_dvb_component (_tmp105_, &_tmp106_);
											__vala_GstMpegtsComponentDescriptor_free0 (comp);
											comp = _tmp106_;
											_tmp107_ = comp;
											_tmp108_ = event_class;
											dvb_epg_scanner_decode_component (_tmp107_, _tmp108_);
											__vala_GstMpegtsComponentDescriptor_free0 (comp);
											break;
										}
										case GST_MTS_DESC_DVB_CONTENT:
										{
											GPtrArray* conts = NULL;
											GstMpegtsDescriptor* _tmp109_ = NULL;
											GPtrArray* _tmp110_ = NULL;
											GPtrArray* _tmp111_ = NULL;
											gint _tmp112_ = 0;
											gint _tmp113_ = 0;
											_tmp109_ = desc;
											gst_mpegts_descriptor_parse_dvb_content (_tmp109_, &_tmp110_);
											_g_ptr_array_unref0 (conts);
											conts = _tmp110_;
											_tmp111_ = conts;
											_tmp112_ = g_ptr_array_get_length (_tmp111_);
											_tmp113_ = _tmp112_;
											if (_tmp113_ != 0) {
												{
													guint k = 0U;
													k = (guint) 0;
													{
														gboolean _tmp114_ = FALSE;
														_tmp114_ = TRUE;
														while (TRUE) {
															guint _tmp116_ = 0U;
															GPtrArray* _tmp117_ = NULL;
															gint _tmp118_ = 0;
															gint _tmp119_ = 0;
															GstMpegtsContent cont = {0};
															GPtrArray* _tmp120_ = NULL;
															guint _tmp121_ = 0U;
															gconstpointer _tmp122_ = NULL;
															DVBLoggingLogger* _tmp123_ = NULL;
															GstMpegtsContent _tmp124_ = {0};
															GstMpegtsContentNibbleHi _tmp125_ = 0;
															GstMpegtsContent _tmp126_ = {0};
															guint8 _tmp127_ = 0U;
															GstMpegtsContent _tmp128_ = {0};
															guint8 _tmp129_ = 0U;
															if (!_tmp114_) {
																guint _tmp115_ = 0U;
																_tmp115_ = k;
																k = _tmp115_ + 1;
															}
															_tmp114_ = FALSE;
															_tmp116_ = k;
															_tmp117_ = conts;
															_tmp118_ = g_ptr_array_get_length (_tmp117_);
															_tmp119_ = _tmp118_;
															if (!(_tmp116_ < ((guint) _tmp119_))) {
																break;
															}
															_tmp120_ = conts;
															_tmp121_ = k;
															_tmp122_ = g_ptr_array_index (_tmp120_, _tmp121_);
															cont = *((GstMpegtsContent*) _tmp122_);
															_tmp123_ = dvb_epg_scanner_log;
															_tmp124_ = cont;
															_tmp125_ = _tmp124_.content_nibble_1;
															_tmp126_ = cont;
															_tmp127_ = _tmp126_.content_nibble_2;
															_tmp128_ = cont;
															_tmp129_ = _tmp128_.user_byte;
															dvb_logging_logger_debug (_tmp123_, "EPGScanner.vala:349: 0x%01x, 0x%01x, 0x%02x", (guint) _tmp125_, (guint) _tmp127_, (guint) _tmp129_);
														}
													}
												}
											}
											_g_ptr_array_unref0 (conts);
											break;
										}
										default:
										{
											DVBLoggingLogger* _tmp130_ = NULL;
											GstMpegtsDescriptor* _tmp131_ = NULL;
											guint8 _tmp132_ = 0U;
											_tmp130_ = dvb_epg_scanner_log;
											_tmp131_ = desc;
											_tmp132_ = _tmp131_->tag;
											dvb_logging_logger_debug (_tmp130_, "EPGScanner.vala:357: Unkown descriptor: 0x%02x", (guint) _tmp132_);
											break;
										}
									}
								}
							}
						}
						_tmp133_ = dvb_epg_scanner_log;
						_tmp134_ = event_class;
						_tmp135_ = dvb_event_to_string (_tmp134_);
						_tmp136_ = _tmp135_;
						dvb_logging_logger_debug (_tmp133_, "EPGScanner.vala:364: Adding new event: %s", _tmp136_);
						_g_free0 (_tmp136_);
						_tmp137_ = list;
						_tmp138_ = event_class;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp137_, _tmp138_);
						__vala_GstMpegtsDescriptor_free0 (desc);
						_dvb_event_unref0 (event_class);
					}
				}
			}
			__vala_GstMpegtsEITEvent_free0 (event);
			_g_object_unref0 (list);
		}
		__finally64:
		{
			GeeHashMap* _tmp139_ = NULL;
			_tmp139_ = self->priv->channel_events;
			g_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _dvb_event_video_component_ref0 (gpointer self) {
	return self ? dvb_event_video_component_ref (self) : NULL;
}


static gpointer _dvb_event_audio_component_ref0 (gpointer self) {
	return self ? dvb_event_audio_component_ref (self) : NULL;
}


static gpointer _dvb_event_teletext_component_ref0 (gpointer self) {
	return self ? dvb_event_teletext_component_ref (self) : NULL;
}


static void dvb_epg_scanner_decode_component (GstMpegtsComponentDescriptor* comp, DVBEvent* event_class) {
	GstMpegtsComponentDescriptor* _tmp0_ = NULL;
	guint8 _tmp1_ = 0U;
	g_return_if_fail (comp != NULL);
	g_return_if_fail (event_class != NULL);
	_tmp0_ = comp;
	_tmp1_ = _tmp0_->stream_content;
	switch (_tmp1_) {
		case 0x01:
		case 0x05:
		{
			DVBEventVideoComponent* video = NULL;
			DVBEventVideoComponent* _tmp2_ = NULL;
			GstMpegtsComponentDescriptor* _tmp3_ = NULL;
			guint8 _tmp4_ = 0U;
			GstMpegtsComponentDescriptor* _tmp7_ = NULL;
			guint8 _tmp8_ = 0U;
			GstMpegtsComponentDescriptor* _tmp11_ = NULL;
			guint8 _tmp12_ = 0U;
			GstMpegtsComponentDescriptor* _tmp23_ = NULL;
			guint8 _tmp24_ = 0U;
			GstMpegtsComponentDescriptor* _tmp27_ = NULL;
			guint8 _tmp28_ = 0U;
			DVBEventVideoComponent* _tmp33_ = NULL;
			GstMpegtsComponentDescriptor* _tmp34_ = NULL;
			guint8 _tmp35_ = 0U;
			gchar* _tmp36_ = NULL;
			DVBEventVideoComponent* _tmp37_ = NULL;
			GstMpegtsComponentDescriptor* _tmp38_ = NULL;
			guint8 _tmp39_ = 0U;
			DVBEventVideoComponent* _tmp40_ = NULL;
			GstMpegtsComponentDescriptor* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			DVBEvent* _tmp44_ = NULL;
			DVBEventVideoComponent* _tmp45_ = NULL;
			DVBEventVideoComponent* _tmp46_ = NULL;
			_tmp2_ = dvb_event_video_component_new ();
			video = _tmp2_;
			_tmp3_ = comp;
			_tmp4_ = _tmp3_->component_type;
			switch (_tmp4_) {
				case 0x09:
				case 0x0a:
				case 0x0b:
				case 0x0c:
				case 0x0d:
				case 0x0e:
				case 0x0f:
				case 0x10:
				case 0x80:
				case 0x81:
				case 0x82:
				case 0x83:
				case 0x84:
				{
					DVBEventVideoComponent* _tmp5_ = NULL;
					_tmp5_ = video;
					_tmp5_->has_hd = TRUE;
					break;
				}
				default:
				{
					DVBEventVideoComponent* _tmp6_ = NULL;
					_tmp6_ = video;
					_tmp6_->has_hd = FALSE;
					break;
				}
			}
			_tmp7_ = comp;
			_tmp8_ = _tmp7_->component_type;
			switch (_tmp8_) {
				case 0x80:
				case 0x81:
				case 0x82:
				case 0x83:
				case 0x84:
				{
					DVBEventVideoComponent* _tmp9_ = NULL;
					_tmp9_ = video;
					_tmp9_->has_3d = TRUE;
					break;
				}
				default:
				{
					DVBEventVideoComponent* _tmp10_ = NULL;
					_tmp10_ = video;
					_tmp10_->has_3d = FALSE;
					break;
				}
			}
			_tmp11_ = comp;
			_tmp12_ = _tmp11_->component_type;
			switch (_tmp12_) {
				case 0x01:
				case 0x05:
				case 0x09:
				case 0x0d:
				{
					DVBEventVideoComponent* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp13_ = video;
					_tmp14_ = g_strdup ("4:3");
					_g_free0 (_tmp13_->aspect_ratio);
					_tmp13_->aspect_ratio = _tmp14_;
					break;
				}
				case 0x02:
				case 0x06:
				case 0x0a:
				case 0x0e:
				{
					DVBEventVideoComponent* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp15_ = video;
					_tmp16_ = g_strdup ("16:9 with pan");
					_g_free0 (_tmp15_->aspect_ratio);
					_tmp15_->aspect_ratio = _tmp16_;
					break;
				}
				case 0x03:
				case 0x07:
				case 0x0b:
				case 0x0f:
				case 0x80:
				case 0x81:
				case 0x82:
				case 0x83:
				case 0x84:
				{
					DVBEventVideoComponent* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp17_ = video;
					_tmp18_ = g_strdup ("16:9");
					_g_free0 (_tmp17_->aspect_ratio);
					_tmp17_->aspect_ratio = _tmp18_;
					break;
				}
				case 0x04:
				case 0x08:
				case 0x0c:
				case 0x10:
				{
					DVBEventVideoComponent* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp19_ = video;
					_tmp20_ = g_strdup ("2.21:1");
					_g_free0 (_tmp19_->aspect_ratio);
					_tmp19_->aspect_ratio = _tmp20_;
					break;
				}
				default:
				{
					DVBEventVideoComponent* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					_tmp21_ = video;
					_tmp22_ = g_strdup ("unknown");
					_g_free0 (_tmp21_->aspect_ratio);
					_tmp21_->aspect_ratio = _tmp22_;
					break;
				}
			}
			_tmp23_ = comp;
			_tmp24_ = _tmp23_->component_type;
			switch (_tmp24_) {
				case 0x05:
				case 0x06:
				case 0x07:
				case 0x08:
				case 0x0d:
				case 0x0e:
				case 0x0f:
				case 0x10:
				case 0x82:
				case 0x83:
				{
					DVBEventVideoComponent* _tmp25_ = NULL;
					_tmp25_ = video;
					_tmp25_->frequency = 30;
					break;
				}
				default:
				{
					DVBEventVideoComponent* _tmp26_ = NULL;
					_tmp26_ = video;
					_tmp26_->frequency = 25;
					break;
				}
			}
			_tmp27_ = comp;
			_tmp28_ = _tmp27_->stream_content;
			if (((gint) _tmp28_) == 0x01) {
				DVBEventVideoComponent* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				_tmp29_ = video;
				_tmp30_ = g_strdup ("MPEG-2");
				_g_free0 (_tmp29_->content);
				_tmp29_->content = _tmp30_;
			} else {
				DVBEventVideoComponent* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				_tmp31_ = video;
				_tmp32_ = g_strdup ("AVC/MVC");
				_g_free0 (_tmp31_->content);
				_tmp31_->content = _tmp32_;
			}
			_tmp33_ = video;
			_tmp34_ = comp;
			_tmp35_ = _tmp34_->component_type;
			_tmp36_ = g_strdup_printf ("0x%02x", _tmp35_);
			_g_free0 (_tmp33_->type);
			_tmp33_->type = _tmp36_;
			_tmp37_ = video;
			_tmp38_ = comp;
			_tmp39_ = _tmp38_->component_tag;
			_tmp37_->tag = (guint) _tmp39_;
			_tmp40_ = video;
			_tmp41_ = comp;
			_tmp42_ = _tmp41_->text;
			_tmp43_ = g_strdup (_tmp42_);
			_g_free0 (_tmp40_->text);
			_tmp40_->text = _tmp43_;
			_tmp44_ = event_class;
			_tmp45_ = video;
			_tmp46_ = _dvb_event_video_component_ref0 (_tmp45_);
			_dvb_event_video_component_unref0 (_tmp44_->video_component);
			_tmp44_->video_component = _tmp46_;
			_dvb_event_video_component_unref0 (video);
			break;
		}
		case 0x02:
		case 0x04:
		case 0x06:
		case 0x07:
		{
			DVBEventAudioComponent* audio = NULL;
			DVBEventAudioComponent* _tmp47_ = NULL;
			GstMpegtsComponentDescriptor* _tmp48_ = NULL;
			guint8 _tmp49_ = 0U;
			DVBEventAudioComponent* _tmp58_ = NULL;
			GstMpegtsComponentDescriptor* _tmp59_ = NULL;
			guint8 _tmp60_ = 0U;
			gchar* _tmp61_ = NULL;
			DVBEventAudioComponent* _tmp62_ = NULL;
			GstMpegtsComponentDescriptor* _tmp63_ = NULL;
			guint8 _tmp64_ = 0U;
			DVBEventAudioComponent* _tmp65_ = NULL;
			GstMpegtsComponentDescriptor* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			DVBEventAudioComponent* _tmp69_ = NULL;
			GstMpegtsComponentDescriptor* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			DVBEvent* _tmp73_ = NULL;
			DVBEventAudioComponent* _tmp74_ = NULL;
			DVBEventAudioComponent* _tmp75_ = NULL;
			_tmp47_ = dvb_event_audio_component_new ();
			audio = _tmp47_;
			_tmp48_ = comp;
			_tmp49_ = _tmp48_->stream_content;
			switch (_tmp49_) {
				case 0x02:
				{
					DVBEventAudioComponent* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					_tmp50_ = audio;
					_tmp51_ = g_strdup ("MPEG-1 Layer 2");
					_g_free0 (_tmp50_->content);
					_tmp50_->content = _tmp51_;
					break;
				}
				case 0x04:
				{
					DVBEventAudioComponent* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					_tmp52_ = audio;
					_tmp53_ = g_strdup ("AC-3");
					_g_free0 (_tmp52_->content);
					_tmp52_->content = _tmp53_;
					break;
				}
				case 0x06:
				{
					DVBEventAudioComponent* _tmp54_ = NULL;
					gchar* _tmp55_ = NULL;
					_tmp54_ = audio;
					_tmp55_ = g_strdup ("HE-AAC/HE-AACv2");
					_g_free0 (_tmp54_->content);
					_tmp54_->content = _tmp55_;
					break;
				}
				case 0x07:
				{
					DVBEventAudioComponent* _tmp56_ = NULL;
					gchar* _tmp57_ = NULL;
					_tmp56_ = audio;
					_tmp57_ = g_strdup ("DTS");
					_g_free0 (_tmp56_->content);
					_tmp56_->content = _tmp57_;
					break;
				}
				default:
				break;
			}
			_tmp58_ = audio;
			_tmp59_ = comp;
			_tmp60_ = _tmp59_->component_type;
			_tmp61_ = g_strdup_printf ("0x%02x", _tmp60_);
			_g_free0 (_tmp58_->type);
			_tmp58_->type = _tmp61_;
			_tmp62_ = audio;
			_tmp63_ = comp;
			_tmp64_ = _tmp63_->component_tag;
			_tmp62_->tag = (guint) _tmp64_;
			_tmp65_ = audio;
			_tmp66_ = comp;
			_tmp67_ = _tmp66_->text;
			_tmp68_ = g_strdup (_tmp67_);
			_g_free0 (_tmp65_->text);
			_tmp65_->text = _tmp68_;
			_tmp69_ = audio;
			_tmp70_ = comp;
			_tmp71_ = _tmp70_->language_code;
			_tmp72_ = g_strdup (_tmp71_);
			_g_free0 (_tmp69_->language);
			_tmp69_->language = _tmp72_;
			_tmp73_ = event_class;
			_tmp74_ = audio;
			_tmp75_ = _dvb_event_audio_component_ref0 (_tmp74_);
			_tmp73_->audio_components = g_slist_append (_tmp73_->audio_components, _tmp75_);
			_dvb_event_audio_component_unref0 (audio);
			break;
		}
		case 0x03:
		{
			DVBEventTeletextComponent* teletext = NULL;
			DVBEventTeletextComponent* _tmp76_ = NULL;
			DVBEventTeletextComponent* _tmp77_ = NULL;
			GstMpegtsComponentDescriptor* _tmp78_ = NULL;
			guint8 _tmp79_ = 0U;
			gchar* _tmp80_ = NULL;
			DVBEventTeletextComponent* _tmp81_ = NULL;
			GstMpegtsComponentDescriptor* _tmp82_ = NULL;
			guint8 _tmp83_ = 0U;
			DVBEventTeletextComponent* _tmp84_ = NULL;
			GstMpegtsComponentDescriptor* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			DVBEvent* _tmp88_ = NULL;
			DVBEventTeletextComponent* _tmp89_ = NULL;
			DVBEventTeletextComponent* _tmp90_ = NULL;
			_tmp76_ = dvb_event_teletext_component_new ();
			teletext = _tmp76_;
			_tmp77_ = teletext;
			_tmp78_ = comp;
			_tmp79_ = _tmp78_->component_type;
			_tmp80_ = g_strdup_printf ("0x%02x", _tmp79_);
			_g_free0 (_tmp77_->type);
			_tmp77_->type = _tmp80_;
			_tmp81_ = teletext;
			_tmp82_ = comp;
			_tmp83_ = _tmp82_->component_tag;
			_tmp81_->tag = (guint) _tmp83_;
			_tmp84_ = teletext;
			_tmp85_ = comp;
			_tmp86_ = _tmp85_->text;
			_tmp87_ = g_strdup (_tmp86_);
			_g_free0 (_tmp84_->text);
			_tmp84_->text = _tmp87_;
			_tmp88_ = event_class;
			_tmp89_ = teletext;
			_tmp90_ = _dvb_event_teletext_component_ref0 (_tmp89_);
			_tmp88_->teletext_components = g_slist_append (_tmp88_->teletext_components, _tmp90_);
			_dvb_event_teletext_component_unref0 (teletext);
			break;
		}
		default:
		{
			break;
		}
	}
}


static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBEPGScanner * self;
	GQueue* _tmp0_ = NULL;
	GMainContext* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_epg_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_EPG_SCANNER, DVBEPGScanner);
	_tmp0_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->channels);
	self->priv->channels = _tmp0_;
	self->priv->stop_counter = 0;
	_tmp1_ = g_main_context_new ();
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->channel_events);
	self->priv->channel_events = _tmp2_;
	return obj;
}


static void dvb_epg_scanner_class_init (DVBEPGScannerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_epg_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEPGScannerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_epg_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_epg_scanner_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_epg_scanner_log = _tmp1_;
}


static void dvb_epg_scanner_instance_init (DVBEPGScanner * self) {
	self->priv = DVB_EPG_SCANNER_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_pipeline);
	g_rec_mutex_init (&self->priv->__lock_channel_events);
}


static void dvb_epg_scanner_finalize (GObject* obj) {
	DVBEPGScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_EPG_SCANNER, DVBEPGScanner);
	_g_object_unref0 (self->priv->DeviceGroup);
	g_rec_mutex_clear (&self->priv->__lock_pipeline);
	_g_object_unref0 (self->priv->pipeline);
	__g_queue_free__g_object_unref0_0 (self->priv->channels);
	_g_source_unref0 (self->priv->scan_source);
	_g_source_unref0 (self->priv->queue_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	_g_thread_unref0 (self->priv->worker_thread);
	g_rec_mutex_clear (&self->priv->__lock_channel_events);
	_g_object_unref0 (self->priv->channel_events);
	G_OBJECT_CLASS (dvb_epg_scanner_parent_class)->finalize (obj);
}


GType dvb_epg_scanner_get_type (void) {
	static volatile gsize dvb_epg_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_epg_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_epg_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEPGScanner), 0, (GInstanceInitFunc) dvb_epg_scanner_instance_init, NULL };
		GType dvb_epg_scanner_type_id;
		dvb_epg_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEPGScanner", &g_define_type_info, 0);
		g_once_init_leave (&dvb_epg_scanner_type_id__volatile, dvb_epg_scanner_type_id);
	}
	return dvb_epg_scanner_type_id__volatile;
}



