/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.xpath.XPathException;

public class AnalyzeString
extends Instruction {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private Block matching;
    private Block nonMatching;
    private Pattern pattern;

    public AnalyzeString(Expression expression, Expression expression2, Expression expression3, Block block, Block block2, Pattern pattern) {
        this.select = expression;
        this.regex = expression2;
        this.flags = expression3;
        this.matching = block;
        this.nonMatching = block2;
        this.pattern = pattern;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("analyze-string");
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Object object;
        Controller controller = xPathContext.getController();
        SequenceIterator sequenceIterator = controller.getCurrentIterator();
        RegexIterator regexIterator = controller.getCurrentRegexIterator();
        boolean bl = controller.isTracing();
        String string = this.select.evaluateAsString(xPathContext);
        Pattern pattern = this.pattern;
        if (pattern == null) {
            int n = Matches.setFlags(this.flags.evaluateAsString(xPathContext));
            try {
                object = RegexTranslator.translate(this.regex.evaluateAsString(xPathContext), true);
                pattern = Pattern.compile((String)object, n);
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                throw new XPathException.Dynamic(regexSyntaxException);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        RegexIterator regexIterator2 = new RegexIterator(string, pattern);
        controller.setCurrentIterator(regexIterator2);
        controller.setCurrentRegexIterator(regexIterator2);
        object = xPathContext.newContext();
        ((XPathContext)object).setCurrentIterator(regexIterator2);
        if (bl) {
            Item item;
            InstructionDetails instructionDetails;
            TraceListener traceListener = controller.getTraceListener();
            InstructionDetails instructionDetails2 = this.matching == null ? null : this.matching.getInstructionDetails(controller);
            InstructionDetails instructionDetails3 = instructionDetails = this.nonMatching == null ? null : this.nonMatching.getInstructionDetails(controller);
            while ((item = regexIterator2.next()) != null) {
                if (regexIterator2.isMatching()) {
                    if (this.matching == null) continue;
                    traceListener.enter(instructionDetails2);
                    this.matching.process((XPathContext)object);
                    traceListener.leave(instructionDetails2);
                    continue;
                }
                if (this.nonMatching == null) continue;
                traceListener.enter(instructionDetails);
                this.nonMatching.process((XPathContext)object);
                traceListener.leave(instructionDetails);
            }
        } else {
            Item item;
            while ((item = regexIterator2.next()) != null) {
                if (regexIterator2.isMatching()) {
                    if (this.matching == null) continue;
                    this.matching.process((XPathContext)object);
                    continue;
                }
                if (this.nonMatching == null) continue;
                this.nonMatching.process((XPathContext)object);
            }
        }
        controller.setCurrentIterator(sequenceIterator);
        controller.setCurrentRegexIterator(regexIterator);
        return null;
    }
}

