/*
 * LibrePCB - Professional EDA for everyone!
 * Copyright (C) 2013 Urban Bruhin
 * http://librepcb.org/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBREPCB_PROJECT_CMDFLIPSELECTEDBOARDITEMS_H
#define LIBREPCB_PROJECT_CMDFLIPSELECTEDBOARDITEMS_H

/*****************************************************************************************
 *  Includes
 ****************************************************************************************/
#include <QtCore>
#include <librepcbcommon/undocommandgroup.h>
#include <librepcbcommon/units/all_length_units.h>

/*****************************************************************************************
 *  Namespace / Forward Declarations
 ****************************************************************************************/
namespace librepcb {
namespace project {

class Board;
class BI_Device;

/*****************************************************************************************
 *  Class CmdFlipSelectedBoardItems
 ****************************************************************************************/

/**
 * @brief The CmdFlipSelectedBoardItems class
 */
class CmdFlipSelectedBoardItems final : public UndoCommandGroup
{
    public:

        // Constructors / Destructor
        CmdFlipSelectedBoardItems(Board& board, Qt::Orientation orientation) noexcept;
        ~CmdFlipSelectedBoardItems() noexcept;


    private:

        // Private Methods

        /// @copydoc UndoCommand::performExecute()
        bool performExecute() throw (Exception) override;
        void flipDevice(BI_Device& device, const Point& center) throw (Exception);


        // Private Member Variables

        // Attributes from the constructor
        Board& mBoard;
        Qt::Orientation mOrientation;
};

/*****************************************************************************************
 *  End of File
 ****************************************************************************************/

} // namespace project
} // namespace librepcb

#endif // LIBREPCB_PROJECT_CMDFLIPSELECTEDBOARDITEMS_H
