// 
// CheckBoxBackend.cs
//  
// Author:
//       Lluis Sanchez <lluis@xamarin.com>
// 
// Copyright (c) 2012 Xamarin Inc
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
using System;
using Xwt.Backends;
using MonoMac.AppKit;

namespace Xwt.Mac
{
	public class CheckBoxBackend: ViewBackend<NSButton,ICheckBoxEventSink>, ICheckBoxBackend
	{
		public CheckBoxBackend ()
		{
		}

		public override void Initialize ()
		{
			ViewObject = new MacButton (EventSink, ApplicationContext);
			Widget.SetButtonType (NSButtonType.Switch);
			Widget.Title = "";
		}
		
		#region ICheckBoxBackend implementation
		public void SetContent (IWidgetBackend widget)
		{
		}

		public void SetContent (string label)
		{
			Widget.Title = label;
			ResetFittingSize ();
		}

		public bool Active {
			get {
				return Widget.State == NSCellStateValue.On;
			}
			set {
				Widget.State = value ? NSCellStateValue.On : NSCellStateValue.Off;
			}
		}

		public bool Mixed {
			get {
				return Widget.State == NSCellStateValue.Mixed;
			}
			set {
				Widget.State = value ? NSCellStateValue.Mixed : NSCellStateValue.Off;
			}
		}

		public bool AllowMixed {
			get {
				return Widget.AllowsMixedState;
			}
			set {
				Widget.AllowsMixedState = value;
			}
		}
		#endregion
	}
}

