<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/debugfs.plugin/integrations/power_capping.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/debugfs.plugin/metadata.yaml"
sidebar_label: "Power Capping"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Kernel"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Power Capping


<img src="https://netdata.cloud/img/powersupply.svg" width="150"/>


Plugin: debugfs.plugin
Module: intel_rapl

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Collects power capping performance metrics on Linux systems.


Parse data from `debugfs file.

This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.

This integration requires read access to files under `/sys/devices/virtual/powercap`, which are accessible only to the root user by default. Netdata uses Linux Capabilities to give the plugin access to debugfs. `CAP_DAC_READ_SEARCH` is added automatically during installation. This capability allows bypassing file read permission checks and directory read and execute permission checks. If file capabilities are not usable, then the plugin is instead installed with the SUID bit set in permissions so that it runs as root.


### Default Behavior

#### Auto-Detection

Assuming that debugfs is mounted and the required permissions are available, this integration will automatically detect whether or not the system is using zswap.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

Monitor the Intel RAPL zones Consumption.

### Per Power Capping instance

Global Intel RAPL zones.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cpu.powercap_intel_rapl_zone | Power | Watts |
| cpu.powercap_intel_rapl_subzones | dram, core, uncore | Watts |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### filesystem

The debugfs filesystem must be mounted on your host for plugin to collect data. You can run the command-line (`sudo mount -t debugfs none /sys/kernel/debug/`) to mount it locally. It is also recommended to modify your fstab (5) avoiding necessity to mount the filesystem before starting netdata.



### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:debugfs]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 1 | no |
| command options | Additinal parameters for collector |  | no |

</details>

#### Examples
There are no configuration examples.


