/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Computes the hypotenuse avoiding overflow and underflow.
*
* @param x - number
* @param y - number
* @returns hypotenuse
*
* @example
* var h = hypot( -5.0, 12.0 );
* // returns 13.0
*
* @example
* var h = hypot( NaN, 12.0 );
* // returns NaN
*
* @example
* var h = hypot( -0.0, -0.0 );
* // returns 0.0
*/
declare function hypot( x: number, y: number ): number;


// EXPORTS //

export = hypot;
