###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seamonkey_detect_win.nasl 302 2008-10-03 14:07:35Z oct $
#
# Mozilla Seamonkey Version Detection (Windows)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Upgrade to detect the latest version
# - By Sharath S <sharaths@secpod.com> On 2009-11-02 #5567
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800016);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Mozilla SeaMonkey Version Detection (Windows)");
  desc = "
  Overview : This script finds the Mozilla SeaMonkey installed version on
  Windows and saves in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Mozilla SeaMonkey in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for SeaMonkey version through Registry entry
seaVer = registry_get_sz(key:"SOFTWARE\mozilla.org\SeaMonkey",
                         item:"CurrentVersion");
if(!seaVer)
{
  seaVer = registry_get_sz(key:"SOFTWARE\Mozilla\SeaMonkey",
                           item:"CurrentVersion");
}

if(seaVer)
{
  seaVer = eregmatch(pattern:"[0-9.]+", string:seaVer);
  set_kb_item(name:"Seamonkey/Win/Ver", value:seaVer[0]);
  security_note(data:"Mozilla Seamonkey version " + seaVer[0] + 
                              " was detected on the host");
}
