# tony@libpcap.net
# http://libpcap.net
#
# See the Nessus Scripts License for details

if(description)
{
  script_id(11444);
  script_bugtraq_id(5562);
  script_version ("$Revision: 8287 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2002-0985", "CVE-2002-0986");

  name = "PHP Mail Function Header Spoofing Vulnerability";
  script_name(name);
 
 desc = "
The remote host is running a version of PHP <= 4.2.2.

The mail() function does not properly sanitize user input.
This allows users to forge email to make it look like it is
coming from a different source other than the server.

Users can exploit this even if SAFE_MODE is enabled.

Solution : Contact your vendor for the latest PHP release.
Risk factor : Medium";
  script_description(desc);
 
  summary = "Checks for version of PHP";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  family = "Web application abuses";
  script_family(family);
  script_copyright("(C) tony@libpcap.net");
  script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);


if(get_port_state(port)) {
  banner = get_http_banner(port:port);
  if(!banner)exit(0);

  if(egrep(pattern:".*PHP/([0-3]\..*|4\.[0-1]\..*|4\.2\.[0-2][^0-9])", string:banner)) {
    security_warning(port);
  }
}
 
