##############################################################################
#
#  Microsoft XML Core Services Remote Code Execution Vulnerability (955218)
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/12
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0467
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900058);
  script_bugtraq_id(21872, 32204);
  script_cve_id("CVE-2007-0099", "CVE-2008-4029", "CVE-2008-4033");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_category(ACT_GATHER_INFO);
  script_family("Windows : Microsoft Bulletins");
  script_name("Microsoft XML Core Services Remote Code Execution Vulnerability (955218)");
  script_summary("Check for Hotfix and version of XML File");
  desc = "
  MS08-069

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-069.

  Vulnerability Insight:
  The flaws are due to,
  - a memory corruption error when parsing malformed XML content.
  - the way MSXML handles error checks for external document type definitions
    (DTDs).
  - an error in the way MSXML handles transfer-encoding headers.

  Impact: Successful exploitation could allow attacker to conduct cross domain
  scripting attacks and read data from another domain in IE and also execute
  arbitrary code by tricking a user into visiting a malicious web page.

  Impact Level: System

  Affected Software/OS:
  Microsoft XML Core Services 3.0/4.0/5.0/6.0
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.
  Microsoft Office 2003 & 2007.
  Microsoft Office Compatibility Pack for Word/Excel/PowerPoint 2007 File Formats.

  Fix: Run Windows Update and update the listed hotfixes or download
  and update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-069.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-069.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl", "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file6 = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath + "\msxml6.dll");
file6r = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath + "\msxml6r.dll");
file4 = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath + "\msxml4.dll");
file4a = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath + "\msxml4a.dll");
file4r = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath + "\msxml4r.dll");
file3 = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath + "\msxml3.dll");

# Microsoft Office 2003 & 2007
if((get_kb_item("MS/Office/Ver") =~ "11\..*|12\..*")||
   registry_key_exists(key:"SOFTWARE\Microsoft\Office"))
{
  sharedPath = registry_get_sz(key:"SOFTWARE\Microsoft\Shared Tools",
                               item:"SharedFilesDir");
  if(sharedPath)
  {
    share2 = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sharedPath);
    file5 = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                         string:sharedPath + "OFFICE11\msxml5.dll");
  }
}

# MSXML6.dll < 6.20.1099.0
if(egrep(pattern:"^([0-5]\..*|6\.([01]?[0-9]|20\.(0?[0-9]?[0-9]?[0-9]|10([0-8]" +
                 "[0-9]|9[0-8])))\..*)$",
         string:GetVer(file:file6, share:share)))
{
  security_hole(0);
  exit(0);
}

# MSXML6r.dll < 6.0.3883.0
if(egrep(pattern:"^([0-5]\..*|6\.(0\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-7]" +
                 "[0-9][0-9]|8[0-7][0-9]|88[0-2])))\..*)$",
         string:GetVer(file:file6r, share:share)))
{
  security_hole(0);
  exit(0);
}

# MSXML5.dll < 5.20.1087.0
if(egrep(pattern:"^([0-4]\..*|5\.([01]?[0-9]\..*|20\.([0-9]?[0-9]?[0-9]|10" +
                 "([0-7][0-9]|8[0-6]))\..*))$",
         string:GetVer(file:file5, share:share2)))
{
  security_hole(0);
  exit(0);
}

# MSXML4.dll < 4.20.9870.0
if(egrep(pattern:"^([0-3]\..*|4\.([01]?[0-9]\..*|20\.([0-8]?[0-9]?[0-9]?[0-9]" +
                 "\..*|9([0-7][0-9][0-9]|8[0-6][0-9])\..*)))$",
         string:GetVer(file:file4, share:share)))
{
  security_hole(0);
  exit(0);
}

# MSXML4A.dll < 4.10.9404.0
if(egrep(pattern:"^([0-3]\..*|4\.([0-9]\..*|10\.([0-8]?[0-9]?[0-9]?[0-9]" +
                 "\..*|9([0-3][0-9][0-9]|40[0-3])\..*)))$",
         string:GetVer(file:file4a, share:share)))
{
  security_hole(0);
  exit(0);
}

# MSXML4R.dll < 4.10.9404.0
if(egrep(pattern:"^([0-3]\..*|4\.([0-9]\..*|10\.([0-8]?[0-9]?[0-9]?[0-9]" +
                 "\..*|9([0-3][0-9][0-9]|40[0-3])\..*)))$",
         string:GetVer(file:file4r, share:share)))
{
  security_hole(0);
  exit(0);
}

# MSXML3.dll < 8.100.1048.0
if(egrep(pattern:"^([0-7]\..*|8\.([0-9]?[0-9]\..*|100\.([0-9]?[0-9]?[0-9]" +
                 "\..*|1(0[0-3][0-9]|04[0-7])\..*)))$",
         string:GetVer(file:file3, share:share))){
  security_hole(0);
}
exit(0);
