###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-019.nasl 2770 2009-06-10 11:13:42Z jun $
#
# Cumulative Security Update for Internet Explorer (969897)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900364);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2007-3091", "CVE-2009-1140", "CVE-2009-1141", "CVE-2009-1528",
                "CVE-2009-1529", "CVE-2009-1530", "CVE-2009-1531", "CVE-2009-1532");
  script_bugtraq_id(24283, 35200, 35198, 35222, 35223, 35224, 35234, 35235);
  script_name("Cumulative Security Update for Internet Explorer (969897)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-019.

  Vulnerability Insight:
  Mulitple flaws are due to,
  - Scripts may persist across navigations and let a malicious site interact with
    a site in an arbitrary external domain.
  - When application fails to properly enforce the same-origin policy.
  - In the way that Internet Explorer caches data and incorrectly allows the
    cached content to be called, potentially bypassing Internet Explorer domain
    restriction.
  - Error in the way Internet Explorer displays a Web page that contains certain
    unexpected method calls to HTML objects.
  - Error in the way Internet Explorer accesses an object that has not been
    correctly initialized or has been deleted by specially crafted Web page.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes into the
  context of the affected system, as a result in view, change, or delete data
  and can cause denial of service to legitimate users.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Internet Explorer version 5.x/6.x/7.x/8.x

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-019.mspx

  References:
  http://support.microsoft.com/kb/969897
  http://www.microsoft.com/technet/security/Bulletin/MS09-019.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# MS09-019 Hotfix (969897)
if(hotfix_missing(name:"969897") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for mshtml.dll version 5.0 < 5.0.3877.2200
  if(version_in_range(version:vers, test_version:"5.0",
                      test_version2:"5.0.3877.2199")){
    security_hole(0);
  }
  # Check for mshtml.dll version 6.0 < 6.0.2800.1627
  else if(version_in_range(version:vers, test_version:"6.0",
                           test_version2:"6.0.2800.1626")){
    security_hole(0);
  }
  security_hole(0);
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.3562
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.2900.3561")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.5803 or 7.0 < 7.0.6000.16850
    # or 8.0 < 8.0.6001.18783
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.2900.5802") ||
       version_in_range(version:vers, test_version:"7.0",
                        test_version2:"7.0.6000.16849") ||
       version_in_range(version:vers, test_version:"8.0",
                        test_version2:"8.0.6001.18782")){
      security_hole(0);
    }
  }
  security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.3790.4504 or 7.0 < 7.0.6000.16850
    # or 8.0 < 8.0.6001.18783
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.3790.4503") ||
      version_in_range(version:vers, test_version:"7.0",
                        test_version2:"7.0.6000.16849") ||
      version_in_range(version:vers, test_version:"8.0",
                        test_version2:"8.0.6001.18782")){
      security_hole(0);
    }
  }
  security_hole(0);
}
