# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:008
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63736);
 script_cve_id("CVE-2008-0928", "CVE-2008-1945", "CVE-2008-2025", "CVE-2008-2382", "CVE-2008-4311", "CVE-2008-4539", "CVE-2008-5498", "CVE-2008-5557", "CVE-2008-5714", "CVE-2009-0021", "CVE-2009-0115", "CVE-2009-0186", "CVE-2009-0754", "CVE-2009-1148", "CVE-2009-1149", "CVE-2009-1150", "CVE-2009-1151");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "SuSE Security Summary SUSE-SR:2009:008";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:008.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:008";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update18~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update18~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update18~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update18~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update18~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_update18~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u13~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u13~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u13~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u13~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u13~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u13~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile", rpm:"libsndfile~1.0.17~171.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-devel", rpm:"libsndfile-devel~1.0.17~171.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-octave", rpm:"libsndfile-octave~1.0.17~171.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-progs", rpm:"libsndfile-progs~1.0.17~171.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qemu", rpm:"qemu~0.10.1~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"timezone", rpm:"timezone~2009d~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-demo", rpm:"java-1_5_0-sun-demo~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_update18~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-demo", rpm:"java-1_6_0-sun-demo~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u13~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile", rpm:"libsndfile~1.0.17~141.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-devel", rpm:"libsndfile-devel~1.0.17~141.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-octave", rpm:"libsndfile-octave~1.0.17~141.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-progs", rpm:"libsndfile-progs~1.0.17~141.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.9~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qemu", rpm:"qemu~0.10.1~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-demo", rpm:"java-1_5_0-sun-demo~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_update18~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-debuginfo", rpm:"java-1_6_0-sun-debuginfo~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-demo", rpm:"java-1_6_0-sun-demo~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u12~1.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile", rpm:"libsndfile~1.0.17~81.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-devel", rpm:"libsndfile-devel~1.0.17~81.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-octave", rpm:"libsndfile-octave~1.0.17~81.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-progs", rpm:"libsndfile-progs~1.0.17~81.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mhash", rpm:"php5-mhash~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.9~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qemu", rpm:"qemu~0.10.1~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
