#!/usr/bin/env python

from __future__ import absolute_import, print_function

import sys


travis_template = """\
# AUTO-GENERATED BY tox2travis.py -- DO NOT EDIT THIS FILE BY HAND!

sudo: false
language: python
python: 2.7

cache: false

env:
  {envs}

install:
  - pip install tox codecov

script:
  - tox -e $TOX_ENV

after_success:
  - codecov

notifications:
  email: false

# Don't fail on trunk versions.
matrix:
  allow_failures:
    - env: TOX_ENV=pypy-twisted_trunk-pyopenssl_trunk
    - env: TOX_ENV=py27-twisted_trunk-pyopenssl_trunk
    - env: TOX_ENV=py33-twisted_trunk-pyopenssl_trunk
    - env: TOX_ENV=py34-twisted_trunk-pyopenssl_trunk
    - env: TOX_ENV=py35-twisted_trunk-pyopenssl_trunk

branches:
  only:
    - master

# AUTO-GENERATED BY tox2travis.py -- DO NOT EDIT THIS FILE BY HAND!"""


if __name__ == "__main__":
    line = sys.stdin.readline()
    tox_envs = []
    while line:
        tox_envs.append(line)
        line = sys.stdin.readline()

    print(travis_template.format(
        envs='  '.join(
            '- TOX_ENV={0}'.format(env) for env in tox_envs)))
