/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#ifndef QSOURCEHIGHLIGHTFRAME_H
#define QSOURCEHIGHLIGHTFRAME_H

#include <QFrame>

class QSplitter;

namespace Ui {
    class QSourceHighlightFrame;
}

namespace srchiliteqt {
    class TextEditHighlighted;
}

class QSourceHighlightFrame : public QFrame {
    Q_OBJECT
public:
    QSourceHighlightFrame(QWidget *parent = 0);
    ~QSourceHighlightFrame();

    srchiliteqt::TextEditHighlighted *getInputTextEdit() const;
    srchiliteqt::TextEditHighlighted *getOutputTextEdit() const;

    QSplitter *splitter();

    void setPreviewContents(const QString &contents);
    void setNoPreview();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::QSourceHighlightFrame *m_ui;
};

#endif // QSOURCEHIGHLIGHTFRAME_H
