% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctionsSSH.R
\name{makeClusterFunctionsSSH}
\alias{makeClusterFunctionsSSH}
\title{ClusterFunctions for Remote SSH Execution}
\usage{
makeClusterFunctionsSSH(workers, fs.latency = 65)
}
\arguments{
\item{workers}{[\code{list} of \code{\link{Worker}}]\cr
List of Workers as constructed with \code{\link{Worker}}.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
Jobs are spawned by starting multiple R sessions via \code{Rscript} over SSH.
If the hostname of the \code{\link{Worker}} equals \dQuote{localhost},
\code{Rscript} is called directly so that you do not need to have an SSH client installed.
}
\note{
If you use a custom \dQuote{.ssh/config} file, make sure your
ProxyCommand passes \sQuote{-q} to ssh, otherwise each output will
end with the message \dQuote{Killed by signal 1} and this will break
the communication with the nodes.
}
\examples{
\dontrun{
# cluster functions for multicore execution on the local machine
makeClusterFunctionsSSH(list(Worker$new("localhost", ncpus = 2)))
}
}
\seealso{
Other ClusterFunctions: 
\code{\link{makeClusterFunctionsDocker}()},
\code{\link{makeClusterFunctionsInteractive}()},
\code{\link{makeClusterFunctionsLSF}()},
\code{\link{makeClusterFunctionsMulticore}()},
\code{\link{makeClusterFunctionsOpenLava}()},
\code{\link{makeClusterFunctionsSGE}()},
\code{\link{makeClusterFunctionsSlurm}()},
\code{\link{makeClusterFunctionsSocket}()},
\code{\link{makeClusterFunctionsTORQUE}()},
\code{\link{makeClusterFunctions}()}
}
\concept{ClusterFunctions}
