% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_parameters.R
\name{cmds}
\alias{cmds}
\title{Classical Multidimensional Scaling (cMDS)}
\usage{
cmds(x, n = "all", distance = "euclidean", ...)
}
\arguments{
\item{x}{A dataframe or a statistical model.}

\item{n}{Number of components to extract. If \code{n="all"}, then \code{n} is set as the number of variables minus 1 (\code{ncol(x)-1}). If \code{n="auto"} (default) or \code{n=NULL}, the number of components is selected through \code{\link{n_factors}}. In \code{\link{reduce_parameters}}, can also be \code{"max"}, in which case it will select all the components that are maximally pseudo-loaded (i.e., correlated) by at least one variable.}

\item{distance}{The distance measure to be used. This must be one of "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski". Any unambiguous substring can be given.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Also referred to as principal Coordinates Analysis (PCoA), Classical Multidimensional Scaling (cMDS) takes a set of dissimilarities (i.e., a distance matrix) and returns a set of points such that the distances between the points are approximately equal to the dissimilarities.
}
\examples{
cmds(iris[, 1:4])
}
\references{
\itemize{
 \item Nguyen, L. H., \& Holmes, S. (2019). Ten quick tips for effective dimensionality reduction. PLOS Computational Biology, 15(6).
}
}
