use strict;
use warnings;

use RT::Test tests => undef;

plan skip_all => 'valid SQL only on mysql'
    unless RT->Config->Get('DatabaseType') eq 'mysql';

my ($base, $m) = RT::Test->started_ok;
ok $m->login, "logged in";

my $t = RT::Ticket->new( RT->SystemUser );
$t->Create(
    Queue   => 1,
    Subject => 'seed',
);
ok $t->id, 'created seed ticket';

my $root = RT::User->new( RT->SystemUser );
$root->Load('root');
my $password = $root->__Value('Password');
ok $password, 'pulled hashed password from db';

my $sql = q[1 union select 1+id as id, 1+id as EffectiveId, 1 as Queue, 'ticket' as Type, 0 as IssueStatement, 0 as Resolution, 12 as Owner, Password as Subject, 0 as InitialPriority, 0 as FinalPriority, 0 as Priority, 0 as TimeEstimated, 0 as TimeWorked, Name as Status, 0 as TimeLeft, null as Told, null as Starts, null as Started, null as Due, null as Resolved, 0 as LastUpdatedBy, null as LastUpdated, 6 as Creator, null as Created, 0 as Disabled from Users];
RT::Interface::Web::EscapeURI(\$sql);

$m->get_ok("$base/Search/Results.html?Format=id,Subject,Status;Query=id%3E0;OrderBy=|;Rows=$sql");
$m->content_lacks($password, "our password hash doesn't show up!");
$m->warning_like(qr/isn't numeric/);

undef $m;
done_testing;
