## TFSA-2021-123: Null pointer dereference in `UncompressElement`

### CVE Number
CVE-2021-37649

### Impact
The code for `tf.raw_ops.UncompressElement` can be made to trigger a null
pointer dereference:

```python
import tensorflow as tf

data = tf.data.Dataset.from_tensors([0.0])
tf.raw_ops.UncompressElement(
  compressed=tf.data.experimental.to_variant(data),
  output_types=[tf.int64],
  output_shapes=[2])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/f24faa153ad31a4b51578f8181d3aaab77a1ddeb/tensorflow/core/kernels/data/experimental/compression_ops.cc#L50-L53)
obtains a pointer to a `CompressedElement` from a `Variant` tensor and then
proceeds to dereference it for decompressing. There is no check that the
`Variant` tensor contained a `CompressedElement`, so the pointer is actually
`nullptr`.

### Patches
We have patched the issue in GitHub commit
[7bdf50bb4f5c54a4997c379092888546c97c3ebd](https://github.com/tensorflow/tensorflow/commit/7bdf50bb4f5c54a4997c379092888546c97c3ebd).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
