/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998, 1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_GNOME
#if HAVE_CONFIG_H
#include <config.h>
#endif
#if ! ENABLE_NLS
//    #define _(str) str
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str 
#endif
#include <vdkb2/vdkb_gnomeappbar.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBGnomeAppBar
// put here vdk class name string
#define VDK_CLASS "VDKGnomeAppBar"
// put here vdk class name
#define VDK_ANCESTOR  VDKGnomeAppBar
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "gnomeappbar"
//=================================================================

extern char* wi_widget_prompts[];
static char buff[128];
/*
   properties
*/
char* vdkgnomeappbar_props[] =
{ STATUS_INTERNAL,PROGRESS_INTERNAL,0 };

int CLASS::Counter = 0;
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDKBEvGnomeAppBar);
DEFINE_EVENT_LIST(CLASS,VDKBEvGnomeAppBar);
///////////////////////////////////////////////////

/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner,
		  bool has_progress,
		  bool has_status):
  VDKBEvGnomeAppBar(owner,
		    has_progress,
		    has_status),
  VDKBObject(name)
{
  // newly constructed widget counter is incremented
  // each time
  Counter++;
  int t;
  for(t=0; vdkgnomeappbar_props[t]; t++)
    proplist.add(VDKBProperty(vdkgnomeappbar_props[t]));
  SetPropValue(JUSTIFY_INTERNAL,"r_justify");
  SetPropValue(EXPAND_INTERNAL,CHECK_FALSE);
  SetPropValue(FILL_INTERNAL,CHECK_FALSE);
  SetPropValue(STATUS_INTERNAL,CHECK_TRUE);
  SetPropValue(PROGRESS_INTERNAL,
	       has_progress ? CHECK_TRUE : CHECK_FALSE);
  // assign this to VDKBObject <object> member.
  object = this;
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
    // a weird patch, for an obscure reason bkg goes to grey
    // so we force it to nihil
  SetPropValue(NORMALBACKGROUND,NIHIL_PROP);
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	  PROP_STATUS_INTERNAL,
	  (char*) GetProp(STATUS_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_PROGRESS_INTERNAL,
	  (char*) GetProp(PROGRESS_INTERNAL));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* statusbar = NULL;
  // autogenerate first suitable button counter
  // to ensure unicity
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    // actually makes widget
    {
      statusbar = new CLASS(buff,owner);
      statusbar->SetSize(30,20);
    }
  // add widget to form
  return owner->AddToSelf(statusbar,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  bool have_status = false,have_progress = false;
  // gets widget name and parent name
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];

  if(parser.GetParam(arg,buffer,PROP_PROGRESS_INTERNAL) &&
     !strcmp(arg,CHECK_TRUE))
      have_progress= true;
  sprintf(tmp,"\n%s = new VDKGnomeAppBar(this,%s,true);",
	  obj_name,
	  have_progress ? "true" : "false");
  strcpy(source,tmp);

  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // get code that adds widget to container
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(tmp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(tmp,"\nAdd(%s",obj_name);
  strcat(source,tmp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(tmp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,tmp);
    }
  else
    {
      sprintf(tmp,");");
      strcat(source,tmp);
    }
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
		    char* buffer,
		    VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[32];
  CLASS* statusbar;
  // get name and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
      return false;
  bool have_status = true,have_progress = false;
  if(parser.GetParam(arg,buffer,PROP_PROGRESS_INTERNAL) &&
     !strcmp(arg,CHECK_TRUE))
      have_progress= true;	
  statusbar = new CLASS(obj_name,owner,have_progress,have_status);
  statusbar->SetSize(30,20);
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
      owner->PackToSelf(statusbar, NULL, buffer, parser, obj_parent);
    else
	{
	    VDKObject* p = owner->ChildWithName(obj_parent);
	    VDKBEventContainer* container =
		p ? dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
	    // container NULL causes bar to be added directly
	    // to form inner box.
	    if(container)
		owner->PackToSelf(statusbar, container,
				  buffer,  parser, NULL);
	    else
		{
		    statusbar->Destroy();
		    return false;
		}
	}
  return true;
}

/*
 */
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
    VDKString True = CHECK_TRUE;
    inspector = isp;
    VDKFrame* xframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
    // shadow
    VDKTable *table = new VDKTable(inspector,1,2);
    table->SetSize(219,-1);
    has_progress = new VDKCheckButton(inspector,_(wi_widget_prompts[34]));
    has_progress->Checked = GetProp(PROGRESS_INTERNAL) == True;
    table->AddToCell(has_progress,0,1);
    has_progress->Parent(this);
    SignalConnect(has_progress,"toggled",&CLASS::OnSetProgress);
    xframe->Add(table,l_justify,false,false,false);
    return xframe;
}

bool
CLASS:: OnSetProgress(VDKObject*)
{
    GnomeAppBar* bar = GNOME_APPBAR(statusbar->Widget());
    if(has_progress->Checked)
	gtk_widget_show(bar->progress);
    else
      gtk_widget_hide(bar->progress);
    SetPropValue(PROGRESS_INTERNAL,
		 has_progress->Checked ?
		 CHECK_TRUE : CHECK_FALSE);
    inspector->FormNeedToBeChanged();
    return true;
}
#endif






